clear all

* Set Folder to input one

cd ..\Inputs

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "GDPC1.xls", ///
sheet(FRED Graph) cellrange(B11) firstrow clear

save GDPC1, replace

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "CBO Real Potential GDP.xls", ///
sheet(Vintages) cellrange(A1) firstrow clear

* Generate date variables and rearrange

rename observation_date date
gen year=year(date)
gen month=month(date)
gen day=day(date)
drop if year<1960
egen tt=group(date)
order date tt year month day

joinby year month using GDPC1, unmatched(master)
tab _merge
drop _merge

gen time=year+(month-1)/12

foreach var in 	GDPPOT_20070124 GDPPOT_20080123 GDPPOT_20090108 ///
				GDPPOT_20100126 GDPPOT_20110202 GDPPOT_20120131 ///
				GDPPOT_20130205 GDPPOT_20140204 GDPPOT_20150126 ///
				GDPPOT_20160125 GDPPOT_20170124 GDPC1 {
	gen log_`var'=log(`var')
	sum log_`var' if year==2007 & month==1
	replace log_`var'=log_`var'-r(mean)
}	

twoway ///
(line log_GDPPOT_20070124 time if time>=2004 & time<=2017, lcolor(red)) ///
(line log_GDPPOT_20090108 time if time>=2004 & time<=2017, lcolor(green) lpattern(dash_dot)) ///
(line log_GDPPOT_20110202 time if time>=2004 & time<=2017, lcolor(blue) lpattern(dash)) ///
(line log_GDPPOT_20130205 time if time>=2004 & time<=2017, lcolor(black) lpattern(shortdash)) ///
(line log_GDPPOT_20150126 time if time>=2004 & time<=2017, lcolor(teal) lpattern(shortdash_dot)) ///
(line log_GDPPOT_20170124 time if time>=2004 & time<=2017, lcolor(purple) lpattern(longdash)) ///
(line log_GDPC1 time if time>=2004 & time<=2017, lcolor(black) lwidth(thick)) ///		
, ///
xlabel(2004(1)2017) xtitle("") ///
ylabel(-0.1(0.05)0.25) ytitle("log deviation from 2007Q1") ///
legend(	label(1 "CBO 2007") label(2 "CBO 2009") label(3 "CBO 2011") ///
label(4 "CBO 2013") label(5 "CBO 2015") label(6 "CBO 2017") ///
label(7 "actual") ring(0) position(11) rows(4)) ///
graphregion(color(white)) bgcolor(white)
